#include "bitmap.hpp"
#include "gl.h"

PixelInfo pixelInfo32 = {
	0xff0000,// Red mask in color ( color's type : int )
	0,	// how many bits to shift right to convert color(int) to the actual pixel value 
	0xff0000,// the Red value in pixel
	16,	// how many bits to shift right to get Red value from pixel
	0xff0000,	// green
	0,
	0xff0000,
	8,
	0xff0000,	//blue
	0,
	0xff0000,
	0
};

DWORD Bitmap32::GetPixel( int x, int y )
{
	if( x < 0 || x >= width || y < 0 || y >= height )
		return -1;
	
	return (( long* )line[y])[x];
}

// drawMode will do its work
// solid xor blend
void Bitmap32::PutPixel( int x, int y )
{
	if( clip ){
		if( x < cl || x >= cr || y < ct || y >= cb )
			return;
	}
	else{
		if( x < 0 || x >= width || y < 0 || y >= height )
			return;
	}
	
	long pixel = color;
	
	if( drawMode & XorMode )
		pixel ^= *(long*)( line[y] + x * 4 );
	else if( drawMode & AlphaMode )
		pixel = pixel;	// how to do alpha blend ?
		
	*(long*)( line[y] + x * 4 ) = pixel;
}

// set current draw color
void Bitmap32::SetColor( int color )
{
	Bitmap32::color = color & 0xffffff;
}

void Bitmap32::SetColorKey( int color )
{
	Bitmap32::colorKey = color & 0xffffff;
}

// void Bitmap32::BlitMask( ....... )
BLITMASK( 32 )

void Bitmap32::Blit( Bitmap* dest, int x, int y, int sx, int sy, int w, int h )
{
	BLITCLIP()
	
	if( dest == this ){
		if( y >= sy )
			BlitInside32( x, y, sx, sy, w, h );
		else if( y == sy && sx < x )
			BlitInside32( x, y, sx, sy, w, h );
		else
			BlitOutside32( (Bitmap32*)dest, x, y, sx, sy, w, h );
	}
	else{
		BlitOutside32( (Bitmap32*)dest, x, y, sx, sy, w, h );
	}
}

// the source bitmap and the destination bitmap are the same bitmap  
// reverse must be considered
void Bitmap32::BlitInside32( int x, int y, int sx, int sy, int w, int h )
{
	char** line = Bitmap32::line;

	__asm{
		push es
		mov ax, ds
		mov es, ax
		/* copy from the bottom to the top */
		mov eax, sy
		mov ebx, h
		dec ebx
		add eax, ebx
		mov sy, eax
		add y, ebx
		inc ebx
		
		mov ecx, w
		mov edx, sx
		dec ecx
		add edx, ecx
		mov sx, edx
		add x, ecx
		std
		inc ecx
		shl sx, 2
		shl x, 2
		mov edx, y
		shl eax, 2
		shl edx, 2
		
	blitinside32_dw:
		mov ecx, w
		mov esi, line
		mov edi, esi
		mov esi, dword ptr [esi+eax]
		add esi, sx
		mov edi, dword ptr [edi+edx]
		add edi, x
		repnz movsd
		sub eax, 4
		sub edx, 4
		dec ebx
		jnz blitinside32_dw
		
		pop es
	}
}

// blit from a bitmap to another bitmap
// no reverse at all
void Bitmap32::BlitOutside32( Bitmap32* dest, int x, int y, int sx, int sy, int w, int h )
{
	char** dline = dest->line;
	char** sline = Bitmap32::line;

	__asm{
		push es
		mov ax, ds
		mov es, ax
		
		mov ebx, h
		mov eax, y
		mov edx, sy
		shl eax, 2
		shl edx, 2
		cld
		shl sx, 2
		shl x, 2
		
		blitoutside32_dwloop:
		mov ecx, w 	/* source bitmap line */
		mov esi, sline
		mov esi, [esi+edx]
		add esi, sx
		mov edi, dline 	/* destination bitmap line */
		mov edi, dword ptr [edi+eax]
		add edi, x
		repnz movsd
		add edx, 4
		add eax, 4
		dec ebx
		jnz blitoutside32_dwloop
		
		pop es
	}
}

// blit to another bitmap with SOURCE color key
void Bitmap32::BlitMasked32( Bitmap32* dest, int x, int y, int sx, int sy, int w, int h )
{
	char** dline = dest->line;
	char** sline = Bitmap32::line;
	int colorkey = Bitmap32::colorKey;

	__asm{
		push es
		mov ax, ds
		mov es, ax
		
		mov eax, colorkey
		mov ebx, h
		shl y, 2
		shl sy, 2
		shl sx, 2
		shl x, 2
		
	blitmasked32_dw:
		mov esi, sline
		add esi, sy
		mov esi, [esi]
		add esi, sx
		mov edi, dline
		add edi, y
		mov edi, [edi]
		add edi, x
		mov ecx, w
		
	blitmasked32_loop:
		mov edx, ds:[esi] 	/* source pixel */
		add esi, 4
		cmp edx, eax 	/* is equal colorkey ? */
		je blitmasked32_skip
		mov es:[edi], edx
	blitmasked32_skip:
		add edi, 4
		loop blitmasked32_loop
		
		add y, 4
		add sy, 4
		dec ebx
		jnz blitmasked32_dw
		pop es
	}
}

// clear a rectangle area with the color
// clip will do its work
void Bitmap32::Clear( int l, int t, int w, int h, int color )
{
	char **line = Bitmap32::line;
	
	if( clip ){
		if( l < cl ){
			w -= cl - l;
			l = cl;
		}
		if( t < ct ){
			h -= ct - t;
			t = ct;
		}
		if( l + w > cr )
			w = cr - l;
		if( t + h > cb )
			h = cb - t;
	}
	else{
		if( l < 0 ){
			w += l;
			l = 0;
		}
		if( t < 0 ){
			h += t;
			t = 0;
		}
		if( l + w > width )
			w = width - l;
		if( t + h > height )
			h = height - t;
	}
	
	__asm{
		push es
		mov ax, ds
		mov es, ax
		
		mov eax, color
		mov edx, t
		mov ebx, h
		shl edx, 2
		cld
		mov esi, l
		shl esi, 2
		mov ecx, w
		and ecx, 1
		jnz clear32_1dw
		
	clear32_dw:
		mov edi, line
		mov edi, [edi+edx]
		add edi, esi
		mov ecx, w
		repnz stosd
		add edx, 4
		dec ebx
		jnz clear32_dw
		jmp clear32_end
		
	clear32_1dw:
		mov edi, line
		mov edi, [edi+edx]
		add edi, esi
		stosd
		add edx, 4
		dec ebx
		jnz clear32_1dw
		
		clear32_end:
		pop es
	}
}

Bitmap* Bitmap32::ConvertFormat( int colordepth )
{
	return NULL;
}

